clear; clc

%add folder path and filename
myfolder='';
smooth_factor=3;
smooth_type='movmean';
make_plot = 0 ; 

num_plot_profiles = length(dir(fullfile(myfolder,'*.csv')))/2;

final = NaN(30,num_plot_profiles);

for m = 1:num_plot_profiles

filename_1= [num2str(m),'_','green']; %bigger
filename_2= [num2str(m),'_', 'red' ];%smaller

%load file in
profile_1_raw=csvread([myfolder,'/',filename_1,'.csv'],1,0);
profile_2_raw=csvread([myfolder,'/',filename_2,'.csv'],1,0);

%smooth data
profile_1 = smoothdata(profile_1_raw, smooth_type,smooth_factor);
profile_2 = smoothdata(profile_2_raw, smooth_type,smooth_factor);

width = size((profile_1_raw),2)/2;


for n=1:width
    
    disp(n)
    
    diameter_1 = NaN;
    diameter_2 = NaN;
    
    temp_profile_1 = 0;
    temp_profile_2 = 0;
    
    %'bigger' plot profile
    temp_profile_1 = [profile_1_raw(:,2*n-1) , profile_1(:,2*n)];
    
    length_profile_1 = length(nonzeros(temp_profile_1(:,2)));
    half_1 = round(length_profile_1/2);
    
    left_peaks_1 = findpeaks(temp_profile_1(1:half_1,2));
    left_peak_1 = max(left_peaks_1);
    
    right_peaks_1 = findpeaks(temp_profile_1(half_1:end,2));
    right_peak_1 = max(right_peaks_1);
    
    if isempty(left_peak_1) == 1 |  isempty(right_peak_1) == 1
    
        disp('NaN')
        
    else
        
        left_index_1 = find(temp_profile_1(1:half_1,2) == left_peak_1);
        left_x_1 = temp_profile_1(left_index_1(1),1);
        
        right_index_1 = find(temp_profile_1(half_1:end,2) == right_peak_1) + half_1 -1;
        right_x_1 = temp_profile_1(right_index_1(1),1);
        
        diameter_1 = right_x_1 - left_x_1;
        
        if make_plot == 1
            
            figure(1)
            plot(profile_1_raw(:,2*n-1) ,   normalize(profile_1_raw(:,2*n),'range'))
            hold on
            plot(temp_profile_1(:,1), normalize(temp_profile_1(:,2), 'range'))
            xline(left_x_1)
            xline(right_x_1)
            waitforbuttonpress
            close(1)
            
        else
        end
        
    end
    
    %'smaller' plot profile
    temp_profile_2 = [profile_2_raw(:,2*n-1) , profile_2(:,2*n)];
    
    length_profile_2 = length(nonzeros(temp_profile_2(:,2)));
    half_2 = round(length_profile_2/2);
    
    left_peaks_2 = findpeaks(temp_profile_2(1:half_2,2));
    left_peak_2 = max(left_peaks_2);
    
    right_peaks_2 = findpeaks(temp_profile_2(half_2:end,2));
    right_peak_2 = max(right_peaks_2);
    
    if isempty(left_peak_2) == 1 |  isempty(right_peak_2) == 1
        
        disp('NaN')
        
    else
        
        left_index_2 = find(temp_profile_2(1:half_1,2) == left_peak_2);
        left_x_2 = temp_profile_2(left_index_2(1),1);
        
        right_index_2 = find(temp_profile_2(half_1:end,2) == right_peak_2) + half_1 -1;
        right_x_2 = temp_profile_2(right_index_2(1),1);
        
        diameter_2 = right_x_2 - left_x_2;
        
        if make_plot ==1
            
            figure(2)
            plot(profile_2_raw(:,2*n-1), normalize(profile_2_raw(:,2*n), 'range'))
            hold on
            plot(temp_profile_2(:,1), normalize(temp_profile_2(:,2), 'range'))
            xline(left_x_2)
            xline(right_x_2)
            waitforbuttonpress
            close(2)
  
            
        else
        end
        
        
    end
    
    distance_nm = (diameter_1 - diameter_2)/2*1000;    
    final(n,m) = distance_nm;
    
end



end

final_list=final(isnan(final)==0);
nanmean(nanmean(final_list))

final_table = array2table(final_list);
final_table.Properties.VariableNames = {'Distance_nm'};

writetable(final_table,'summary_distance.csv');